/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entities.shot;

import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import reliquary.entities.shot.ShotEntityBase;
import reliquary.init.ModEntities;
import reliquary.reference.ClientReference;

public class ExorcismShotEntity
extends ShotEntityBase {
    public ExorcismShotEntity(EntityType<ExorcismShotEntity> entityType, Level world) {
        super(entityType, world);
    }

    public ExorcismShotEntity(Level world, Player player, InteractionHand hand) {
        super((EntityType)ModEntities.EXORCISM_SHOT.get(), world, player, hand);
    }

    @Override
    void doFlightEffects() {
        if (this.ticksInAir % 3 == 0) {
            double gauss = this.gaussian(1.0);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_(), this.m_20186_(), this.m_20189_(), gauss, gauss, 0.0);
        }
    }

    @Override
    void doFiringEffects() {
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123770_, this.m_20185_() + this.smallGauss(0.1), this.m_20186_() + this.smallGauss(0.1), this.m_20189_() + this.smallGauss(0.1), 0.5, 0.5, 0.5);
        this.spawnMotionBasedParticle((ParticleOptions)ParticleTypes.f_123744_);
    }

    @Override
    void doBurstEffect(Direction sideHit) {
    }

    @Override
    void spawnHitParticles(int i) {
        for (int particles = 0; particles < i; ++particles) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123770_, this.m_20185_() + this.smallGauss(0.1), this.m_20186_() + this.smallGauss(0.1), this.m_20189_() + this.smallGauss(0.1), this.posGauss(1.0), this.posGauss(1.0), 0.0);
        }
    }

    private boolean isUndead(LivingEntity e) {
        return e.m_6336_() == MobType.f_21641_;
    }

    @Override
    int getRicochetMax() {
        return 1;
    }

    @Override
    int getDamageOfShot(LivingEntity e) {
        return (this.isUndead(e) ? 9 + this.d3() : 0) + 8 + this.d6();
    }

    @Override
    public ResourceLocation getShotTexture() {
        return ClientReference.EXORCISM;
    }
}

